#version 150

#moj_import <minecraft:light.glsl>
#moj_import <minecraft:fog.glsl>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;
in vec3 Normal;

uniform sampler2D Sampler0;
uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform vec3 ModelOffset;
uniform int FogShape;
uniform float GameTime;

out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;

out float isSky;
out vec4 skyColor0;
out vec4 skyColor1;
out vec3 vertexPos;

void main() {
    vertexPos = Position + ModelOffset;
    gl_Position = ProjMat * ModelViewMat * vec4(vertexPos, 1.0);

    vec2 atlasSize = textureSize(Sampler0, 0);
    vec2 onepixel = 1./atlasSize;

    isSky = 0.0;
    vec4 vertexFlag = textureLod(Sampler0, vec2(UV0.x, UV0.y),0);
    if(vertexFlag.a > 0.98 && vertexFlag.a < 0.999){
        if(vertexFlag.r < 0.1 && vertexFlag.g > 0.9 && vertexFlag.b > 0.9) {
            isSky = 1.0;
        }
    }

    vertexDistance = fog_distance(vertexPos, FogShape);
    vertexColor = Color * minecraft_sample_lightmap(Sampler2, UV2);
    texCoord0 = UV0;
}
