#version 150

#moj_import <minecraft:fog.glsl>

uniform sampler2D Sampler0;

uniform mat4 ModelViewMat;
uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;
uniform vec2 ScreenSize;
uniform mat4 ProjMat;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;
in vec4 normal;

in float isSky;
in vec4 skyColor0;
in vec4 skyColor1;
in vec3 vertexPos;

out vec4 fragColor;

#define PI 3.14159

vec3 rgb(float r, float g, float b) {
    return vec3(r / 255, g / 255, b / 255);
}

vec4 lerpColor(vec3 x, vec3 y, float t) {
    return vec4(mix(x.x, y.x, t), mix(x.y, y.y, t), mix(x.z, y.z, t), 1.0);
}

vec3 rgb2hsv(vec3 c) {
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));
    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    vec3 hsv = vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
    return hsv;
}

void main() {
    vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
#ifdef ALPHA_CUTOUT
    if (color.a < ALPHA_CUTOUT) {
        discard;
    }
#endif
    
    if(isSky > 0.0) {
        vec3 defaultColor_0 = rgb(44, 173, 255);
        vec3 defaultColor_1 = rgb(255, 255, 255);
        vec3 defaultColor_sun = rgb(255, 255, 190);
        vec3 defaultColor;
        vec3 voidColor_0 = rgb(81, 56, 117);
        vec3 voidColor_1 = rgb(141, 80, 102);
        vec3 voidColor_sun = rgb(217, 228, 255); // Basically it's a moon
        vec3 voidColor;
        float fade_0 = 0.25;
        float fade_1 = -0.15;
        float sun_fade_0 = 0.992;
        float sun_fade_1 = 0.980;

        float brightness = pow(rgb2hsv(FogColor.xyz).z, 6);

        vec3 v = normalize(vertexPos);

        if(v.y <= fade_0 && v.y >= fade_1) {
            float mix_value = (sin(PI * (v.y - fade_1) / (fade_0 - fade_1) - PI / 2.0) + 1.0) / 2.0;
            defaultColor = lerpColor(defaultColor_1, defaultColor_0, mix_value).xyz;
            voidColor = lerpColor(voidColor_1, voidColor_0, mix_value).xyz;
        }
        else if(v.y > fade_0){
            defaultColor = defaultColor_0;
            voidColor = voidColor_0;
        }
        else{
            defaultColor = defaultColor_1;
            voidColor = voidColor_1;
        }

        // Sun overrides everything written above
        if(v.y > sun_fade_0){
            defaultColor = defaultColor_sun;
            voidColor = voidColor_sun;
        }
        else if(v.y <= sun_fade_0 && v.y >= sun_fade_1){
            // Radial fading
            float mix_value = (sin(PI * (v.y - sun_fade_1) / (sun_fade_0 - sun_fade_1) - PI / 2.0) + 1.0) / 2.0;
            // Use precalculated colors above to not hardcode them
            // Theoretically we can implement a rotating sun/moon
            // But it will require us to rewrite some code here
            defaultColor = lerpColor(defaultColor, defaultColor_sun, mix_value).xyz;
            voidColor = lerpColor(voidColor, voidColor_sun, mix_value).xyz;
        }


        fragColor = lerpColor(voidColor, defaultColor, brightness);

    }
    else fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
